import os
from dataclasses import dataclass
from dotenv import load_dotenv

# Load .env from project root (or parents)
load_dotenv()


@dataclass
class Settings:
    bale_token: str
    bale_base_url: str
    long_poll_timeout: int = 25


def get_settings() -> Settings:
    token = os.getenv("BALE_BOT_TOKEN", "").strip()
    if not token:
        raise RuntimeError("BALE_BOT_TOKEN is not set in environment or .env file")
    base_url = f"https://tapi.bale.ai/bot{token}"
    return Settings(bale_token=token, bale_base_url=base_url)
