# راهنمای کامل استقرار و اجرای ربات ضمانت / کاتالوگ

این نسخه روی **هاست اشتراکی + cPanel + Python / Passenger** طراحی شده و از **MySQL روی VPS** به‌جای SQLite استفاده می‌کند.

ساختار مهم پروژه:

- سورس اصلی ربات: `src_original/`
- وب‌اپ (Flask + وبهوک): `app/`
- WSGI برای Passenger: `wsgi/passenger_wsgi.py`
- تنظیمات محیطی: `.env`
- لاگ‌ها: `tmp/` و `logs/`

---

## ۱. آماده‌سازی دیتابیس MySQL روی VPS

روی VPS (از طریق phpMyAdmin یا ترمینال MySQL) دستورات زیر را اجرا کنید:

```sql
CREATE DATABASE IF NOT EXISTS botnegar_safeganjineh
  CHARACTER SET utf8mb4
  COLLATE utf8mb4_unicode_ci;

CREATE USER IF NOT EXISTS 'botnegar_ganjinehadmin'@'%'
  IDENTIFIED BY 'Zaqwer159';

GRANT ALL PRIVILEGES ON botnegar_safeganjineh.* TO 'botnegar_ganjinehadmin'@'%';
FLUSH PRIVILEGES;
```

> اگر هاست شما فقط اتصال لوکال را قبول می‌کند، به‌جای `%` بنویسید `localhost` و دقت کنید که IP هاست اصلی اجازه دسترسی به MySQL روی VPS را داشته باشد (فایروال / Security Group).

در صورت نیاز، در فایل `.env` پارامترهای زیر را تغییر دهید:

```env
MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_DB=botnegar_safeganjineh
MYSQL_USER=botnegar_ganjinehadmin
MYSQL_PASSWORD=Zaqwer159
```

---

## ۲. تنظیم فایل `.env`

فایل `.env` در روت پروژه توسط هم Flask و هم ربات استفاده می‌شود.

نمونه تنظیمات مهم:

```env
TELEGRAM_BOT_TOKEN=8541088671:AAGvKa7BPFUN2rts44i7nHM9-kBQZ1TD3XM
ADMIN_IDS=100970431,5034192858,119119806,1372667993

CHANNEL_ID=-1003316184303
INVITE_LINK=https://t.me/cnl_iransafebox
CHANNEL_USERNAME=@cnl_iransafebox

WEBHOOK_BASE_URL=https://qverify.botnegar.ir
WEBHOOK_SECRET_PATH=qv_Secret_9kP227

APP_LOG_FILE=tmp/app.log
VAZIR_FONT_PATH=public/fonts/Vazirmatn-Regular.ttf
REQUIRE_CHANNEL_MEMBERSHIP=false

MYSQL_HOST=localhost
MYSQL_PORT=3306
MYSQL_DB=botnegar_safeganjineh
MYSQL_USER=botnegar_ganjinehadmin
MYSQL_PASSWORD=Zaqwer159
```

نکات:

- `TELEGRAM_BOT_TOKEN` حتماً باید توکن جدید ربات باشد (در این نسخه هماهنگ شده است).
- مقدار `WEBHOOK_BASE_URL` را با دامنه/ساب‌دامین واقعی هاست خودتان هماهنگ کنید.
- اگر عضو شدن در کانال اجباری است: `REQUIRE_CHANNEL_MEMBERSHIP=true` و تنظیم `CHANNEL_ID` / `CHANNEL_USERNAME` را چک کنید.

---

## ۳. آپلود پروژه روی هاست اشتراکی (cPanel)

1. در cPanel یک **Python App** جدید بسازید.
   - Python Version: 3.11 یا نزدیک.
   - Application Root: مسیر فولدر پروژه (مثال: `AllBots/qverify`).
   - Application URL: دامنه/ساب‌دامینی که می‌خواهید ربات روی آن باشد.
2. کل پوشه‌ی پروژه را در همان مسیر Application Root آپلود و اکسترکت کنید.
3. مطمئن شوید ساختار به‌صورت زیر است:
   - `wsgi/passenger_wsgi.py`
   - `app/`
   - `src_original/`
   - `.env`
   - `requirements.txt`
4. در صفحه تنظیم Python App، داخل محیط مجازی (Virtualenv) دستور زیر را بزنید:

```bash
pip install -r requirements.txt
```

این دستور این پکیج‌ها را نصب می‌کند (از جمله `python-telegram-bot` و `PyMySQL`).

---

## ۴. تنظیم Passenger / WSGI

در cPanel، مسیر فایل WSGI را روی این مقدار تنظیم کنید:

```text
wsgi/passenger_wsgi.py
```

فایل `wsgi/passenger_wsgi.py` به این شکل است و اپ Flask را برای Passenger آماده می‌کند:

```python
import os, sys
project_root = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
if project_root not in sys.path:
    sys.path.insert(0, project_root)
from app import application  # exposes 'application' for Passenger
```

بعد از ذخیره تنظیمات، از صفحه Python App روی **Restart** کلیک کنید.

---

## ۵. بررسی سلامت اپلیکیشن

پس از ری‌استارت:

1. در مرورگر آدرس زیر را باز کنید:

   ```text
   https://YOUR-DOMAIN/health
   ```

2. اگر همه‌چیز درست باشد، پاسخ JSON مانند زیر می‌گیرید:

   ```json
   {
     "ok": true,
     "has_token": true,
     "token_prefix": "8541088671:AA...",
     "mode": "ptb_adapter"
   }
   ```

3. در صورت خطا:
   - فایل لاگ `tmp/app.log` را بررسی کنید.
   - اگر Passenger خطایی نمایش دهد، آن را نیز بررسی کنید.

---

## ۶. تنظیم و مدیریت وبهوک تلگرام

اسکریپت مدیریت وبهوک در `scripts/manage_webhook.py` قرار دارد.

### ۶.۱. فعال‌سازی وبهوک

در محیط Python App (همان Virtualenv):

```bash
python scripts/manage_webhook.py set
```

این اسکریپت با استفاده از تنظیمات `.env`، آدرس وبهوک را به‌شکل زیر روی ربات ست می‌کند:

```text
{WEBHOOK_BASE_URL}/webhook/{WEBHOOK_SECRET_PATH}
```

مثال:

```text
https://qverify.botnegar.ir/webhook/qv_Secret_9kP227
```

### ۶.۲. مشاهده وضعیت وبهوک

```bash
python scripts/manage_webhook.py info
```

### ۶.۳. حذف وبهوک

```bash
python scripts/manage_webhook.py delete
```

---

## ۷. نحوه کار دیتابیس MySQL در این نسخه

فایل `src_original/db.py` کاملاً به MySQL منتقل شده است.

اتصال:

```python
import pymysql

def _connect():
    return pymysql.connect(
        host=MYSQL_HOST,
        port=MYSQL_PORT,
        user=MYSQL_USER,
        password=MYSQL_PASSWORD,
        database=MYSQL_DB,
        charset="utf8mb4",
        autocommit=False,
    )
```

تابع `init_db()` در ابتدای `main()` در `src_original/bot_ptb.py` اجرا می‌شود و جدول‌های زیر را در دیتابیس می‌سازد (اگر وجود نداشته باشند):

- `guarantees`  (اطلاعات گارانتی‌ها)
- `stores`      (کد و نام فروشگاه‌ها)
- `catalogs`    (کد و عنوان کاتالوگ‌ها)
- `catalog_files` (فایل‌های مربوط به هر کاتالوگ)

> دقت کنید خود دیتابیس (`CREATE DATABASE ...`) را باید **دستی** روی MySQL ساخته باشید. `init_db()` فقط جدول‌ها را می‌سازد.

---

## ۸. منطق جدید کاتالوگ‌ها (لیست دکمه + دریافت فایل)

### ۸.۱. دکمه «کاتالوگ کالا»

در منوی ربات، ادمین با انتخاب گزینه «کاتالوگ کالا» (برچسب `LBL_CATALOG_SEARCH`) وارد گفت‌وگو می‌شود:

1. ربات پیام می‌دهد:  
   «کد یا عنوان کالا را ارسال کنید تا لیست کاتالوگ‌های مرتبط به‌صورت دکمه نمایش داده شود.»
2. شما بخشی از **کد** یا **عنوان** کاتالوگ را ارسال می‌کنید.
3. ربات حداکثر ۱۰ نتیجه اول را پیدا می‌کند و برای هر نتیجه یک **دکمه اینلاین** می‌سازد:

   - متن هر دکمه: `عنوان (کد) [تعداد فایل]`
   - `callback_data` هر دکمه: `catalog:CODE`

4. پیام نتایج با `InlineKeyboardMarkup` ارسال می‌شود. اگر نتایج زیاد باشد، یک توضیح اضافه نمایش داده می‌شود که فقط چند مورد اول نشان داده شده‌اند.

### ۸.۲. دریافت فایل با فشردن دکمه

وقتی روی یکی از دکمه‌ها کلیک می‌کنید:

- تابع `catalog_send_files_callback` اجرا می‌شود.
- کد کاتالوگ از `callback_data` خوانده می‌شود.
- عنوان و کد از دیتابیس (`get_catalog_by_code`) گرفته می‌شود.
- لیست فایل‌های کاتالوگ از `list_catalog_files(code)` خوانده می‌شود.
- اگر **هیچ فایلی ثبت نشده باشد**:

  ```text
  فایلی برای این کاتالوگ ثبت نشده است.
  ```

- اگر فایل‌ها موجود باشند:
  - بار اول، سند با کپشن شامل عنوان، کد و «تعداد فایل» ارسال می‌شود.
  - بقیه‌ی فایل‌ها با کپشن نام فایل (در صورت وجود) ارسال می‌شوند.
  - روی خطا در ارسال فایل، پیام زیر ظاهر می‌شود:

    ```text
    دریافت فایل ناموفق بود.
    ```

- در تمام این مراحل، کیبورد منوی اصلی (برای ادمین / کاربر) همراه پیام‌ها باقی می‌ماند.

---

## ۹. نکته بسیار مهم: توکن جدید و `file_id`‌های تلگرام

با تغییر توکن ربات:

- **تمام `file_id`‌های قبلی که با ربات قدیمی ذخیره شده‌اند، دیگر قابل استفاده نیستند.**
- این موضوع مستقل از نوع دیتابیس است؛ یعنی حتی اگر دیتابیس را از SQLite به MySQL منتقل کنید، `file_id`های قدیمی برای توکن جدید کار نخواهند کرد.

بنابراین:

1. پس از استقرار نسخه جدید و اطمینان از اتصال MySQL:
2. با یک ادمین وارد ربات شوید.
3. از منوی «مدیریت کاتالوگ‌ها»:
   - کاتالوگ‌های لازم را ایجاد کنید (کد + عنوان).
   - برای هر کاتالوگ، فایل‌ها را **دوباره** از طریق تلگرام آپلود کنید.
4. این کار باعث می‌شود `file_id`های جدید مربوط به همین توکن در جدول `catalog_files` ذخیره شوند.
5. از این لحظه به بعد، دکمه‌های کاتالوگ و دریافت فایل بدون خطای «دریافت فایل ناموفق بود» کار می‌کنند.

---

## ۱۰. رفع اشکال و لاگ‌ها

در صورت بروز مشکل:

1. **لاگ وب‌اپ**: فایل `tmp/app.log`
2. **لاگ ربات**: فایل `logs/bot.log` (در صورت فعال بودن لاگ در تنظیمات)
3. گزارش خطای Passenger در cPanel

در صورت دیدن پیغام مشابه با «دریافت فایل ناموفق بود»:

- ابتدا بررسی کنید برای آن کاتالوگ واقعاً فایل ثبت شده و `file_id` جدید است.
- اگر توکن را دوباره تغییر داده‌اید، باید مجدداً فایل‌ها را با توکن جدید بارگذاری کنید.

---
