from __future__ import annotations

import os
from dataclasses import dataclass

from dotenv import load_dotenv

load_dotenv()


@dataclass
class Settings:
    bale_token: str
    bale_base_url: str
    long_poll_timeout: int = 25
    board_repo_backend: str = "sqlite"  # یا "memory"


_settings: Settings | None = None


def get_settings() -> Settings:
    global _settings
    if _settings is not None:
        return _settings

    token = os.getenv("BALE_TOKEN", "").strip()
    base_url = os.getenv("BALE_BASE_URL", "").strip()
    if not base_url:
        base_url = "https://tapi.bale.ai/bot"
    long_poll_timeout = int(os.getenv("LONG_POLL_TIMEOUT", "25"))
    backend = os.getenv("BOARD_REPO_BACKEND", "sqlite").strip().lower()

    _settings = Settings(
        bale_token=token,
        bale_base_url=base_url,
        long_poll_timeout=long_poll_timeout,
        board_repo_backend=backend,
    )
    return _settings
