from __future__ import annotations

from typing import Dict

from bot.models import Board
from bot.storage import BoardRepository


class InMemoryBoardRepository(BoardRepository):
    """ریپازیتوری ساده در حافظه، فقط برای تست/توسعه."""

    def __init__(self) -> None:
        self._boards: Dict[int, Board] = {}

    def get_board(self, chat_id: int) -> Board:
        if chat_id not in self._boards:
            self._boards[chat_id] = Board(chat_id=chat_id)
            self._boards[chat_id].ensure_default_columns()
        return self._boards[chat_id]

    def save_board(self, board: Board) -> None:
        self._boards[board.chat_id] = board
