from __future__ import annotations

from datetime import datetime
from typing import List

from bot.models import Task
from bot.services.tasks_service import TasksService, FlowStats


class ReportingService:
    def __init__(self, tasks_service: TasksService) -> None:
        self.tasks_service = tasks_service

    def format_backlog(self, chat_id: int) -> str:
        tasks = self.tasks_service.list_backlog(chat_id)
        if not tasks:
            return "📭 Backlog خالی است."
        lines: List[str] = ["📋 Backlog:", ""]
        for t in sorted(tasks, key=lambda x: x.id):
            lines.append(f"{t.id}. {t.title}")
        return "\n".join(lines)

    def format_tasks_list(self, title: str, tasks: List[Task]) -> str:
        if not tasks:
            return f"{title}\n\n(موردی نیست)"
        lines: List[str] = [title, ""]
        for t in sorted(tasks, key=lambda x: x.id):
            blocked = "🚧" if t.is_blocked else ""
            lines.append(f"{t.id}. {t.title} {blocked}")
        return "\n".join(lines)

    def format_flow_stats(self, stats: FlowStats) -> str:
        if stats.total_done == 0:
            return "در بازه‌ی انتخابی هیچ کاری Done نشده."
        lines: List[str] = []
        lines.append(f"✅ جمع کارهای Done: {stats.total_done}")
        lines.append(f"⏱ میانگین Lead Time: {stats.avg_lead_time_days:.1f} روز")
        lines.append("📈 Done در هر روز:")
        for day, cnt in sorted(stats.done_per_day.items()):
            lines.append(f"  {day}: {cnt}")
        return "\n".join(lines)

    def format_aging_wip(self, items) -> str:
        if not items:
            return "در این ستون کاری در جریان نیست."
        lines: List[str] = ["⏳ عمر تسک‌های در جریان:", ""]
        for t, age in items:
            lines.append(f"{t.id}. {t.title} → {age:.1f} روز در جریان")
        return "\n".join(lines)
