# Bale Team Task Bot (اسکرامبان / مدیریت کار تیمی در بله)

این پروژه یک ربات بله است که برای مدیریت کارهای تیمی در یک گروه طراحی شده و به سبک اسکرامبان کار می‌کند:

- تعریف کار (تسک) و ستون‌های برد (Backlog, Ready, Doing, Done, ...)
- Pull کردن کارها توسط اعضا
- مدیریت WIP در ستون Doing
- ثبت Block / Unblock
- گزارش‌های جریان کار (Flow) و Aging WIP
- Standup روزانه ساده
- **مدیریت نقش‌ها (Owner, Product Owner, Scrum Master, Developer, Viewer)** و منوی دکمه‌ای بر اساس نقش

## ساختار پروژه

```text
bale-team-bot-roles-menu/
├─ src/
│  ├─ bot/
│  │  ├─ main.py               # نقطه ورود ربات (python -m bot.main)
│  │  ├─ models.py             # مدل‌های Board / Task / ...
│  │  ├─ handlers/
│  │  │  ├─ commands.py        # هندلر تمام دستورات و دکمه‌ها
│  │  ├─ services/
│  │  │  ├─ bale_api.py        # ارتباط با API بله
│  │  │  ├─ tasks_service.py   # منطق برد و تسک‌ها
│  │  │  ├─ standup_service.py # منطق Standup
│  │  │  ├─ report_service.py  # ساخت متن گزارش‌ها
│  │  │  ├─ roles_service.py   # مدیریت اعضا و نقش‌ها
│  │  ├─ storage/
│  │  │  ├─ memory_repo.py     # ذخیره در حافظه (برای تست)
│  │  │  ├─ sqlite_repo.py     # ذخیره در SQLite (واقعی)
│  ├─ config/
│  │  ├─ settings.py           # خواندن تنظیمات از .env
│  ├─ utils/
│  │  ├─ logging_utils.py      # تنظیم لاگ‌گیری
│  │  ├─ validators.py         # توابع کمکی برای پارس ورودی‌ها
│  ├─ scripts/
│  │  ├─ init_db.py            # ساخت اسکیمای SQLite
├─ tests/                      # (در آینده برای تست‌ها)
├─ .env.example
├─ requirements.txt
└─ README.md
```

## نصب و اجرا

1. مخزن را دانلود و از حالت فشرده خارج کنید:

   ```bash
   cd bale-team-bot-roles-menu
   python -m venv .venv
   .venv\Scripts\activate  # در ویندوز
   pip install -r requirements.txt
   ```

2. فایل `.env.example` را کپی و نامش را `.env` بگذارید و مقدار `BALE_TOKEN` را با توکن ربات بله‌ی خودتان پر کنید:

   ```bash
   cp .env.example .env
   # ویرایش .env و تنظیم BALE_TOKEN
   ```

3. ساخت اسکیمای SQLite (از داخل پوشه‌ی `src`):

   ```bash
   cd src
   python -m scripts.init_db
   ```

4. اجرای ربات (هنوز داخل `src`):

   ```bash
   python -m bot.main
   ```

بعد از بالا آمدن ربات، آن را به گروه (Group) خودتان اضافه کنید و مطمئن شوید که پیام‌های گروه را می‌بیند.

## منوی اصلی ربات

در گروه، به ربات دستور زیر را بدهید:

```text
/menu
```

ربات یک **Reply Keyboard** پایین صفحه برای شما باز می‌کند. بسته به نقش شما، دکمه‌های مختلفی را خواهید دید:

- `📋 برد` → نمایش برد کارها
- `🙋 کارهای من` → لیست کارهای assign شده به شما
- `🧲 Pull کار` → کشیدن یک کار از Backlog برای خودتان
- `🚧 کارهای Blocked` → لیست کارهای بلاک‌شده
- `📣 Standup امروز` → خلاصه Standup امروز

برای نقش‌های قوی‌تر:

- `➕ تعریف کار جدید` → فقط Product Owner یا Owner
- `🧱 ستون‌ها / WIP` → فقط Owner
- `👥 اعضا / نقش‌ها` → فقط Owner (مدیریت نقش اعضا)
- `📊 آمار جریان` → Owner و Scrum Master

## نقش‌ها (Roles)

نقش‌ها طبق طراحی اسکرامبان هستند:

- `owner` → مالک برد/گروه
- `po` → Product Owner
- `sm` → Scrum Master
- `dev` → Developer
- `viewer` → مشاهده‌گر

**نکته مهم:** اولین کاربری که ربات او را در یک گروه می‌بیند، به‌صورت خودکار `owner` همان گروه می‌شود.

Owner می‌تواند با دکمه‌ی `👥 اعضا / نقش‌ها` لیست اعضا را ببیند و برای هر نفر نقش تعیین کند.


## راه‌اندازی دیتابیس

برای ساختن اولیه‌ی دیتابیس SQLite (فایل `bale_team_bot.db`) این مراحل را انجام بده:

```bash
cd bale-team-bot-roles-menu
.\.venv\Scripts\activate  # در ویندوز

cd src
python -m scripts.init_db
# یا
py -m scripts.init_db
```

**نکته:** حتماً قبل از اجرای `scripts.init_db` باید داخل پوشه‌ی `src` باشی؛
وگرنه پایتون پکیج `scripts` را پیدا نمی‌کند و خطای `No module named 'scripts'` می‌گیری.

