from __future__ import annotations
from typing import Optional
from pydantic import BaseModel, UUID4


class CustomerCreate(BaseModel):
    first_name: str
    last_name: str
    phone: str
    postal_code: Optional[str] = None
    address: Optional[str] = None
    delivery_geo: Optional[dict] = None


class CustomerUpdate(BaseModel):
    first_name: Optional[str]
    last_name: Optional[str]
    phone: Optional[str]
    postal_code: Optional[str]
    address: Optional[str]
    delivery_geo: Optional[dict]


class CustomerOut(BaseModel):
    id: UUID4
    user_id: UUID4
    first_name: str
    last_name: str
    phone: str
    postal_code: Optional[str]
    address: Optional[str]


class CustomerSelfRegister(BaseModel):
    first_name: Optional[str] = None
    last_name: Optional[str] = None
    phone: str
    postal_code: Optional[str] = None
    address: str
    delivery_lat: Optional[float] = None
    delivery_lng: Optional[float] = None
    password: str
