import os
import sys
from pathlib import Path

from dotenv import load_dotenv
from asgiref.wsgi import AsgiToWsgi  # asgiref معمولاً همراه FastAPI نصب است

BASE_DIR = Path(__file__).resolve().parent

# اضافه‌کردن ریشه‌ی پروژه به sys.path
if str(BASE_DIR) not in sys.path:
    sys.path.insert(0, str(BASE_DIR))

# تغییر دایرکتوری کاری به ریشه‌ی پروژه
os.chdir(BASE_DIR)

# لود کردن متغیرهای .env
load_dotenv(BASE_DIR / ".env")

# ایمپورت اپ FastAPI
from app.main import app as fastapi_app  # noqa: E402

# Passenger به متغیر application به عنوان WSGI app نیاز دارد
application = AsgiToWsgi(fastapi_app)
