from aiogram.fsm.state import StatesGroup, State


class AdminStates(StatesGroup):
    """استیت‌های بخش مدیریت هایپر (ادمین)."""
    login = State()
    menu = State()


class RegisterMarketStates(StatesGroup):
    """
    استیت‌های ثبت مارکت جدید.
    - flow: در حال حرکت بین مراحل مختلف.
    - awaiting_value: منتظر مقدار متنی از ادمین برای فیلد فعلی.
    """
    flow = State()
    awaiting_value = State()


class ManageTenantStates(StatesGroup):
    """
    استیت‌های مدیریت مارکت‌ها (tenantها):
    - select: انتخاب مارکت از لیست
    - action: انتخاب عملیات روی مارکت
    - edit_profile: در حال انتخاب فیلد پروفایل برای ویرایش
    - awaiting_profile_value: منتظر مقدار جدید برای فیلد انتخاب شده
    """
    select = State()
    action = State()
    edit_profile = State()
    awaiting_profile_value = State()
    awaiting_manager_id = State()
    awaiting_notification_message = State()
    awaiting_notification_confirm = State()


class BaseSettingsStates(StatesGroup):
    menu = State()
    awaiting_value = State()


class LeadStates(StatesGroup):
    """
    استیت‌های «درخواست خرید حساب» (کاربر معمولی):

    1) selecting_plan
        کاربر از منوی اصلی دکمه «📮 درخواست خرید حساب» را می‌زند
        و پلن موردنظر را انتخاب می‌کند.

    2) waiting_phone
        بعد از انتخاب پلن، شماره موبایل را می‌فرستد.

    3) waiting_payment_confirmation
        بعد از ثبت درخواست، منتظر پرداخت است و دکمه
        «✅ پرداخت انجام شد» را می‌بیند.
    """
    selecting_plan = State()
    waiting_phone = State()
    waiting_payment_confirmation = State()
