"""store profile manager ids and payment link settings"""
from alembic import op
import sqlalchemy as sa


revision = "0008_store_profile_settings"
down_revision = "0007_channel_sessions"
branch_labels = None
depends_on = None


def upgrade():
    op.drop_constraint("product_like_ibfk_3", "product_like", type_="foreignkey")
    op.add_column(
        "store_profile",
        sa.Column("manager_telegram_ids", sa.JSON(), nullable=True, server_default=sa.text("'[]'")),
    )
    op.add_column("store_profile", sa.Column("payment_link_template", sa.Text(), nullable=True))
    op.add_column("store_profile", sa.Column("payment_link_note", sa.Text(), nullable=True))

    op.drop_constraint("uq_product_like_session", "product_like", type_="unique")
    op.create_unique_constraint(
        "uq_product_like_user",
        "product_like",
        ["tenant_id", "product_id", "telegram_user_id"],
    )


def downgrade():
    op.create_foreign_key(
        "product_like_ibfk_3",
        "product_like",
        "store_visit",
        ["session_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_constraint("uq_product_like_user", "product_like", type_="unique")
    op.create_unique_constraint(
        "uq_product_like_session",
        "product_like",
        ["session_id", "product_id", "telegram_user_id"],
    )

    op.drop_column("store_profile", "payment_link_note")
    op.drop_column("store_profile", "payment_link_template")
    op.drop_column("store_profile", "manager_telegram_ids")
