import uuid
from fastapi import FastAPI, Request
from fastapi.middleware.cors import CORSMiddleware
from app.core.logging import setup_logging
from app.core.config import get_settings
from app.core.context import set_correlation_id
from app.api.routers import customers, auth, tenants, users, categories, products, cart, orders, payments, reports, leads
from app.api.routers import visits, public


setup_logging()
app = FastAPI(title="Hyper SaaS API", version="1.1")
app.add_middleware(
    CORSMiddleware,
    allow_origins=["*"],
    allow_methods=["*"],
    allow_headers=["*"],
)


@app.middleware("http")
async def correlation_middleware(request: Request, call_next):
    correlation_id = request.headers.get("X-Correlation-Id", str(uuid.uuid4()))
    set_correlation_id(correlation_id)
    response = await call_next(request)
    response.headers["X-Correlation-Id"] = correlation_id
    return response


app.include_router(auth.router)
app.include_router(tenants.router)
app.include_router(users.router)
app.include_router(categories.router)
app.include_router(products.router)
app.include_router(cart.router)
app.include_router(orders.router)
app.include_router(customers.router)
app.include_router(payments.router)
app.include_router(reports.router)
app.include_router(leads.router)
app.include_router(visits.router)
app.include_router(public.router)


@app.get("/health")
def health_check():
    return {"status": "ok"}
