import re


IRAN_PHONE = re.compile(r"^(?:\+?98|0)?9\d{9}$")


def ensure_iran_phone(phone: str) -> str:
    if not IRAN_PHONE.match(phone):
        raise ValueError("invalid iran phone number")
    return phone
