import os
import uuid

import bcrypt
from alembic import op
import sqlalchemy as sa


revision = "0006_seed_hyper_admin"
down_revision = "0005_audit"
branch_labels = None
depends_on = None


def upgrade():
    conn = op.get_bind()

    username = os.getenv("DEFAULT_HYPER_ADMIN_USERNAME", "hyperadmin")
    password = os.getenv("DEFAULT_HYPER_ADMIN_PASSWORD", "supersecret")

    # اگر tenant با code='hyper' وجود دارد، همان را بردار؛ وگرنه بساز
    row = conn.execute(
        sa.text("SELECT id FROM tenant WHERE code = :code"),
        {"code": "hyper"},
    ).fetchone()

    if row:
        tenant_id = row[0]
    else:
        tenant_id = str(uuid.uuid4())
        conn.execute(
            sa.text(
                """
                INSERT INTO tenant (id, code, title)
                VALUES (:id, :code, :title)
                """
            ),
            {"id": tenant_id, "code": "hyper", "title": "Hyper Platform"},
        )

    # ساخت هش پسورد
    pw_hash = bcrypt.hashpw(password.encode("utf-8"), bcrypt.gensalt()).decode("utf-8")
    user_id = str(uuid.uuid4())

    # اگر قبلاً کاربر با همین username برای همین tenant وجود دارد، حذفش کن
    conn.execute(
        sa.text(
            """
            DELETE FROM app_user
            WHERE login_username = :u
              AND tenant_id = :tid
            """
        ),
        {"u": username, "tid": tenant_id},
    )

    # درج کاربر ادمین بدون ستون is_active
    conn.execute(
        sa.text(
            """
            INSERT INTO app_user (id, tenant_id, login_username, password_hash, role, status)
            VALUES (:id, :tenant_id, :username, :password_hash, 'hyper_admin', 'active')
            """
        ),
        {
            "id": user_id,
            "tenant_id": tenant_id,
            "username": username,
            "password_hash": pw_hash,
        },
    )


def downgrade():
    conn = op.get_bind()

    username = os.getenv("DEFAULT_HYPER_ADMIN_USERNAME", "hyperadmin")

    # پیدا کردن tenant مربوط به hyper
    row = conn.execute(
        sa.text("SELECT id FROM tenant WHERE code = :code"),
        {"code": "hyper"},
    ).fetchone()

    if row:
        tenant_id = row[0]

        # حذف فقط کاربر مربوط به همین tenant و همین username
        conn.execute(
            sa.text(
                """
                DELETE FROM app_user
                WHERE login_username = :u
                  AND tenant_id = :tid
                """
            ),
            {"u": username, "tid": tenant_id},
        )

        # حذف tenant مربوطه
        conn.execute(
            sa.text(
                """
                DELETE FROM tenant
                WHERE id = :tid
                """
            ),
            {"tid": tenant_id},
        )
