تنظیم‌ها برای هاست اشتراکی

ریشهٔ اپلیکیشن شما همین ~/public_html/AllBots/Bazarya است؛ همهٔ فایل‌های اجرایی (کد، محیط مجازی، passenger_wsgi.py) باید داخل همین مسیر باشند تا پورتال هاست آن را با دامنهٔ Bazarya.botnegar.ir/botnegar.ir سرو کند.
فایل استارت (Start File) باید passenger_wsgi.py باشد؛ نمونهٔ توصیه‌شده:
# ~/public_html/AllBots/Bazarya/passenger_wsgi.py
import os, sys
from pathlib import Path
from asgiref.wsgi import AsgiToWsgi 
from dotenv import load_dotenv

BASE_DIR = Path(__file__).resolve().parent
sys.path.insert(0, str(BASE_DIR))
os.chdir(BASE_DIR)

load_dotenv(BASE_DIR / ".env")  # در صورت تمایل می‌توانید از PassengerEnvVar هم استفاده کنید

from app.main import app as fastapi_app  # همان FastAPI اصلی
application = AsgiToWsgi(fastapi_app)
مراحل نصب در هاست (یک‌بار)

از طریق SSH یا ترمینال هاست وارد ~/public_html/AllBots/Bazarya شوید.
محیط مجازی بسازید و فعال کنید:
python3.11 -m venv venv
source venv/bin/activate
pip install --upgrade pip
pip install -r requirements.txt asgiref==3.8.1
فایل .env را در همین مسیر بسازید (یا از Environment/PassengerEnvVar استفاده کنید).
به پایگاه‌داده PostgreSQL متصل شوید و مهاجرت‌ها را اجرا کنید:
source venv/bin/activate
alembic upgrade head
مطمئن شوید مسیر logs/ قابل‌نوشتن است (در صورت نیاز chmod 755 logs)، زیرا app/core/logging.py لاگ‌ها را همان‌جا ذخیره می‌کند.
در پورتال هاست، اپلیکیشن Python را با همین ریشه و نسخهٔ 3.11 ثبت کنید، و passenger_wsgi.py را به‌عنوان فایل آغازین معرفی کنید.
با curl https://Bazarya.botnegar.ir/health سلامت API را چک کنید.
نمونهٔ فایل .env برای دامنهٔ شما

# آدرس اینستنس FastAPI
API_BASE_URL=https://Bazarya.botnegar.ir

# اتصال PostgreSQL (آدرس سرویس ابری یا دیتابیس مدیریت‌شده)
DB_DSN=postgresql+psycopg2://<user>:<pass>@<host>:5432/<dbname>

# JWT و امنیت
JWT_SECRET=<عبارت حداقل 16 کاراکتر>
JWT_ALG=HS256
JWT_EXP_MIN=60

# لاگ و پراکسی
LOG_LEVEL=INFO
PROXY_URL=

# توکن‌ها و شناسه‌های تلگرام
HYPER_BOT_TOKEN=<توکن ربات Hyper از BotFather>
STORE_BOT_TOKEN=<توکن ربات Store>
STORE_TENANT_ID=<UUID تننت پیش‌فرض>
STORE_CHANNEL_URL=https://t.me/<channel>
STORE_BOT_USERNAME=<نام کاربری بدون @>
HYPER_ADMIN_TELEGRAM_IDS=123456789,987654321
TELEGRAM_VERIFY_TOKENS=true
DEFAULT_HYPER_ADMIN_USERNAME=admin
DEFAULT_HYPER_ADMIN_PASSWORD=<رمز قوی>

# سایر تنظیمات اختیاری
STORE_BOT_TOKEN=<در صورت چند ربات، از app/bots/manager.py استفاده کنید>
می‌توانید همین مقادیر را به‌جای .env با PassengerEnvVar در .htaccess ثبت کنید تا فایل محرمانه‌ای روی هاست ذخیره نشود.

نکته دربارهٔ ربات‌ها

Hyper Bot (python -m app.bots.hyper.main) و Store Bot Manager (python -m app.bots.manager) باید با اسکریپت‌های Cron یا ابزار نگه‌دارندهٔ جداگانه در هاست اجرا شوند، چون Passenger فقط API را بالا می‌آورد. برای هر کدام یک اسکریپت run_*.sh بسازید، آنها را در Cron (هر دقیقه) اجرا کنید تا اگر فرآیند قطع شد مجدد بالا بیاید.
جمع‌بندی

مسیر اپلیکیشن: ~/public_html/AllBots/Bazarya
دامنه/URL: Bazarya.botnegar.ir
فایل شروع: passenger_wsgi.py (نمونهٔ بالا)
گام‌های نصب: ساخت venv، نصب وابستگی‌ها، ایجاد .env، اجرای alembic upgrade head, تنظیم Passenger، نوشتن Cron برای ربات‌ها.