# گزارش مستند پروژه Bazarya

## معماری کلی
- لایه‌ی FastAPI در `app/main.py:1` آماده‌سازی اپلیکیشن، فعال‌سازی CORS و ثبت همه‌ی روترهای احراز هویت تا بازدید را انجام می‌دهد.
- `app/core/config.py:6` متغیرهای ضروری مثل `DB_DSN`, `JWT_SECRET`, توکن ربات‌ها، تنظیمات زرین‌پال و مسیر لاگ را تعریف می‌کند.
- `app/core/logging.py` لاگ JSON را به کنسول و فایل‌های `logs/hyper_bot`/`logs/store_bot` می‌فرستد و `app/db/session.py:1` اتصال SQLAlchemy را می‌سازد.

## پیکربندی محیط و راه‌اندازی
- README‌‌ی پروژه شیوه‌ی چیدن venv، نصب وابستگی‌ها، اجرای `alembic upgrade head`، فعال‌سازی Passenger (`passenger_wsgi.py`) و تست سلامتی را توضیح می‌دهد.
- فایل `.env` باید متغیرهایی مثل `DB_DSN`, `JWT_SECRET`, `HYPER_BOT_TOKEN`, `STORE_BOT_TOKEN`, `STORE_TENANT_ID`, `STORE_CHANNEL_URL`, `STORE_BOT_USERNAME`, `ACCOUNT_PURCHASE_AMOUNT`, `ZARINPAL_MERCHANT_ID`, `ZARINPAL_CALLBACK_URL` و `PROXY_URL` را داشته باشد تا API و ربات‌ها با خدمات خارجی کار کنند.
- اسکریپت‌های `scripts/run_hyper_bot.sh:1`, `scripts/run_store_manager.sh:1` و `restart_bazarya.sh:1` ربات‌ها را روی هاست نگه می‌دارند و `init_db.py` فقط داده‌های فعلی را پاک و ساختار جدولی جدید را می‌سازد.

## مدل داده‌ی اصلی (`app/models/__init__.py`)
- `Tenant` (خط 35) حاوی کد، عنوان، دسته، آدرس، وضعیت، ربات‌ها، محصولات، سفارش‌ها و کاربران مرتبط است.
- `Bot`, `AppUser`, `StoreProfile`, `Category`, `Product`, `ProductSpec`, `ProductPriceHistory`, `ProductImage`, `StoreCustomer`، `Order`/`OrderItem`, `Payment`, `StoreVisit`, `ProductLike`, `AccountRequest`, `AuditLog` روابط کامل بین فروشنده، کاتالوگ، سفارش، پرداخت، بازدید و لید را نشان می‌دهند.
- وضعیت‌های Enum مثل `order.status`, `payment.status`, `store_visit.status`, `account_request.status` به مدیریت چرخه‌های کار کمک می‌کنند.

## سناریوهای اصلی
### ۱. آنبوردینگ مستاجر
1. Hyper-admin فرم `POST /tenants` (`app/api/routers/tenants.py:23`) را پر می‌کند؛ `create_tenant` (`app/services/tenants.py:23`) شماره تماس را اعتبارسنجی، توکن ربات را تایید، مدیر فروشگاه و پروفایل را می‌سازد.
2. داده‌ها با `PUT /tenants/{tenant_id}`, `POST /tenants/{tenant_id}/admins`, `POST /tenants/{tenant_id}/profile` و `POST /tenants/{tenant_id}/notify` تکمیل یا اصلاح می‌شوند.
3. مسیر عمومی خرید حساب (`/public/account-purchase/init`) اطلاعات را به زرین‌پال می‌فرستد، request_id در `AccountRequest` ثبت می‌شود، و در `callback` پس از پرداخت `create_tenant` اجرا شده و پیام تلگرام برای مالک ارسال می‌شود (`app/api/routers/account_purchase.py:36`).

### ۲. ورود و نقش‌ها
- `POST /auth/login` (`app/api/routers/auth.py:14`) رمز ذخیره‌شده را بررسی، توکن JWT می‌سازد و در صورت وجود `telegram_user_id` آن را با کاربر پیوند می‌دهد.
- `POST /auth/telegram-login` (`app/api/routers/auth.py:39`) با `X-Telegram-User` کاربر را پیدا یا ایجاد می‌کند و توکن جدید صادر می‌کند.
- `app/api/dependencies.py:10` ورود را بررسی می‌کند، نقش‌ها را با `require_roles` محدود می‌سازد و `X-Tenant-Id` را برای context فعال نگاه می‌دارد.

### ۳. مدیریت کاربران
- `GET/POST/PUT/DELETE /users` (`app/api/routers/users.py:9`) اجازه می‌دهد کاربران با نقش `store_admin` یا `store_staff` اضافه، ویرایش یا حذف شوند؛ `app/services/users.py` امنیت رمز و یکتا بودن نام کاربری را تضمین می‌کند.

### ۴. مدیریت کاتالوگ
- دسته‌ها (`/categories`) با لیست، ساخت، بروزرسانی و حذف مدیریت می‌شوند (`app/api/routers/categories.py:1`).
- محصولات (`/products`) (فیلتر بر اساس دسته/وضعیت/جست‌وجو، جزئیات، ساخت، ویرایش، افزودن تصویر/مشخصات، تاریخچه قیمت) در `app/api/routers/products.py:1` exposure شده‌اند.
- `app/services/catalog.py:18` تا `:124` کاتالوگ را هندل می‌کند، قیمت فعلی را از تاریخچه استخراج، تاریخچه را می‌بندد، Specs و تصاویر را تنظیم و قیمت جدید را ثبت می‌کند.

### ۵. گردش سبد و سفارش
- `/cart` (`app/api/routers/cart.py:9`) عملیات شروع، افزودن/حذف آیتم، ذخیره، لغو و تسویه را انجام می‌دهد؛ `cart_service` وضعیت سفارش را بین `cart`, `saved`, `awaiting_payment` و `paid` جا‌به‌جا می‌کند.
- `app/services/cart.py:28` سبد را می‌یابد یا می‌سازد، قیمت‌ها را از `ProductPriceHistory` می‌خواند، اقلام را دوباره محاسبه می‌کند و JSON خروجی را با جزئیات آیتم‌ها/پرداخت‌ها برمی‌گرداند.
- `/orders` (`app/api/routers/orders.py:11`) لیست سفارش‌ها، جزئیات یک سفارش، تسویه دستی و دید مشتری (`/orders/my`) را مدیریت می‌کند.

### ۶. پرداخت‌ها
- ثبت پرداخت جدید در `app/services/payments.py:8` صورت می‌پذیرد؛ به‌روزرسانی وضعیت منجر به تغییر وضعیت سفارش می‌شود (`paid` یا `canceled`).
- `POST /payments/card2card/confirm` و `/payments/online/callback` (`app/api/routers/payments.py:12`) به ترتیب توسط کارکنان و درگاه برای تایید پرداخت فراخوانی می‌شوند.

### ۷. مشتریان و ثبت خودکار
- `GET/POST/PUT /customers` (`app/api/routers/customers.py:1`) اطلاعات مشتریان منطبق با `StoreCustomer` را ویرایش یا اضافه می‌کند و هم‌زمان یک `AppUser` با نقش `customer` ایجاد می‌کند.
- `/public/customers/register` (`app/api/routers/public.py:17`) یک مشتری جدید ثبت کرده، نام کاربری/رمز را تنظیم می‌کند و رکورد `StoreCustomer` را با آدرس و موقعیت مکانی می‌سازد.

### ۸. گزارش‌دهی
- `GET /reports/orders` (`app/api/routers/reports.py:1`) گزارش سفارش‌ها را بین تاریخ‌های ورودی می‌سازد؛ در صورت `export=xlsx` یک فایل Excel قابل دانلود تولید می‌شود.

### ۹. لیدها و خرید حساب
- `POST /leads` (`app/api/routers/leads.py:1`) لید را با اطلاعات تماس ثبت می‌کند.
- ربات Hyper در `app/bots/hyper/account_purchase_handlers.py:222` اطلاعات فرم را گرفته، با `BackendClient.post("/public/account-purchase/init")` لینک پرداخت می‌سازد و کاربر را به زرین‌پال هدایت می‌کند.

### ۱۰. بازدیدها و لایک‌‌ها
- `POST /visits/start`, `/visits/{token}/complete`, `/visits/{token}`, `/visits/likes`, `/{token}/likes`, `/visits/likes` (`app/api/routers/visits.py:1`) بازدید از فروشگاه، پایان جلسه و ثبت لایک را پشتیبانی می‌کنند.
- `app/services/store_visits.py:1` تضمین می‌کند فقط یک جلسه فعال (با `session_token` و `status`) برای هر مخاطب وجود دارد و لایک‌ها فقط برای محصولات همان مستاجر ثبت شده‌اند.

### ۱۱. ربات‌های تلگرام
- Hyper-bot (`app/bots/hyper/main.py`) با `handlers` منوهای ثبت مارکت، مدیریت مستاجر، و ارسال لید را اجرا می‌کند و کیبوردها در `app/bots/hyper/keyboards.py` تعریف شده‌اند.
- Store-bot (`app/bots/store/serve.py`) برای هر فروشگاه جداگانه اجرا شده، `app/bots/store/handlers.py:669` منوی شروع را نشان می‌دهد، ورود مدیر را می‌گیرد (`StoreLoginStates`)، محصولات، دسته‌بندی‌ها و فرایند خرید مشتری را با `BackendClient` هماهنگ می‌کند و FSM مربوطه در `app/bots/store/states.py` تعریف شده است.
- `app/bots/manager.py` نگهبان اجرای چند ربات فروشگاه است، `STORE_TENANT_ID_CTX` را از DB پر می‌کند و با `scripts/run_store_manager.sh` می‌توان بدون تداخل شروع کرد.

### ۱۲. ابزارهای کمکی
- `init_db.py` تنها برای بازسازی سریع جداول است، `passenger_wsgi.py` برای بارگذاری FastAPI در Passenger نیاز است.
- اسکریپت‌های `scripts/run_*` وظیفه‌ی ساخت لاگ، فعال‌سازی venv و اجرای هر سرویس در بک‌گراند را بر عهده دارند.

