from alembic import op
import sqlalchemy as sa

from app.db.types import GUID


TABLE_KWARGS = {"mysql_engine": "InnoDB", "mysql_charset": "utf8mb4"}


revision = "0005_audit"
down_revision = "0004_price_history"
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        "audit_log",
        sa.Column("id", GUID(), primary_key=True),
        sa.Column("tenant_id", GUID(), sa.ForeignKey("tenant.id", ondelete="CASCADE")),
        sa.Column("actor_user_id", GUID(), sa.ForeignKey("app_user.id", ondelete="SET NULL")),
        sa.Column("action", sa.Text(), nullable=False),
        sa.Column("payload", sa.JSON()),
        sa.Column("created_at", sa.TIMESTAMP(timezone=True), server_default=sa.text("CURRENT_TIMESTAMP"), nullable=False),
        **TABLE_KWARGS,
    )
    op.create_index("idx_audit_tenant", "audit_log", ["tenant_id", "created_at"])


def downgrade():
    op.drop_index("idx_audit_tenant", table_name="audit_log")
    op.drop_table("audit_log")
