from __future__ import annotations

from typing import Dict

from bot.models import Board


class InMemoryBoardRepository:
    """Very simple in-memory repo for development / MVP.

    In real deployment you can replace this with a DB-backed repository.
    """

    def __init__(self) -> None:
        self._boards: Dict[int, Board] = {}

    def get_board(self, chat_id: int) -> Board:
        if chat_id not in self._boards:
            board = Board(chat_id=chat_id)
            board.ensure_default_columns()
            self._boards[chat_id] = board
        return self._boards[chat_id]
