# bale-team-bot

Simple Scrumban-style team task bot for **Bale** messenger – MVP structure.

## Structure

```text
bale-team-bot/
├─ src/
│  ├─ bot/
│  │  ├─ main.py
│  │  ├─ models.py
│  │  ├─ handlers/
│  │  │  ├─ commands.py
│  │  │  ├─ callbacks.py
│  │  ├─ services/
│  │  │  ├─ tasks_service.py
│  │  │  ├─ report_service.py
│  │  │  ├─ bale_api.py
│  │  ├─ storage/
│  │  │  ├─ memory_repo.py
│  │  │  ├─ db_repo.py
│  ├─ config/
│  │  ├─ settings.py
│  ├─ utils/
│  │  ├─ logging_utils.py
│  │  ├─ validators.py
├─ tests/
├─ scripts/
├─ .env.example
├─ requirements.txt
├─ README.md
```

## How to run (development)

```bash
cd bale-team-bot
cp .env.example .env   # and put your Bale bot token in BALE_BOT_TOKEN
python -m venv .venv
source .venv/bin/activate  # on Windows: .venv\Scripts\Activate.ps1
pip install -r requirements.txt
cd src
python -m bot.main
```

Then add the bot to a Bale group and try commands like:

- `/backlog_new تست ربات`
- `/backlog`
- `/to_ready 1`
- `/board`
- `/pull`
- `/mytasks`
```
