from __future__ import annotations

from datetime import datetime
from typing import Dict, Tuple, Optional


def parse_int(text: str) -> Tuple[bool, Optional[int]]:
    try:
        return True, int(text.strip())
    except Exception:
        return False, None


def parse_iso_datetime(text: str):
    """پارس ساده‌ی تاریخ/ساعت.

    قالب‌های پشتیبانی‌شده:
    - YYYY-MM-DD
    - YYYY-MM-DD HH:MM
    """
    text = text.strip()
    for fmt in ("%Y-%m-%d", "%Y-%m-%d %H:%M"):
        try:
            dt = datetime.strptime(text, fmt)
            return True, dt
        except Exception:
            continue
    return False, None


def parse_key_value_args(text: str) -> Dict[str, str]:
    """پارس رشته‌ای مثل: key=review name=Review order=3 wip=2 done=true"""
    result: Dict[str, str] = {}
    if not text:
        return result
    parts = text.strip().split()
    for part in parts:
        if "=" not in part:
            continue
        k, v = part.split("=", 1)
        v = v.strip().strip('"').strip("'")
        result[k.strip()] = v
    return result
