from __future__ import annotations

from typing import Protocol

from bot.models import Board


class BoardRepository(Protocol):
    def get_board(self, chat_id: int) -> Board: ...
    def save_board(self, board: Board) -> None: ...


def get_default_repo() -> BoardRepository:
    from config.settings import get_settings
    from bot.storage.memory_repo import InMemoryBoardRepository
    from bot.storage.sqlite_repo import SQLiteBoardRepository

    settings = get_settings()
    backend = settings.board_repo_backend
    if backend == "memory":
        return InMemoryBoardRepository()
    return SQLiteBoardRepository()
